﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.TBI;
using System.Text;
using BusinessHelper = VeteransAffairs.Registries.Business.Utilities.Helpers;

public partial class TBI_Instruments_Whodas_i : BaseTBIInstrumentPage
{

    #region Variable Declarations

    PatientManager patientManager = new PatientManager();
    InstrumentType instrumentType = new InstrumentType();

    protected int _surveyTypeId = 31; // Database Id for World Health Organization Disability Assessment Schedule 2.0 - Interview

    SURVEY _survey;   // the root object in the Survey set
    SURVEY_RESULT _surveyResult; // the object representing the actual data in the Survey

    List<STD_QUESTION> QuestionList = new List<STD_QUESTION>();

    #endregion

    /// <summary>
    /// Default Constructor
    /// </summary>
    public TBI_Instruments_Whodas_i()
    {
        //Manager Save Notification Event Handler
        patientManager.BOSaveSuccess += manager_BOSaveSuccess;
    }

    #region Protected Methods

    /// <summary>
    /// Page Load method
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void Page_Load(object sender, EventArgs e) {
        TBIServiceTO _tbiServiceTo;

        try {
            _tbiServiceTo = (TBIServiceTO)Session["TBIServiceTO"];
            _tbiInstrumentManager.TbiServiceTo = _tbiServiceTo;

            string instTitle = _tbiInstrumentManager.GetInstrumentByID(_surveyTypeId).Name;

            LabelBreadCrumb.Text = "TBI Instruments > Instrument Associations > " + instTitle;
            LabelInstrumentTitle.Text = instTitle;
            Page.Title = "TBI Instruments - " + instTitle;

            if (_tbiInstrumentManager.TbiServiceTo != null) {
                Label labelUser = (Label)Master.FindControl("LabelCurrentUser");
                labelUser.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.UserName);

                LabelPatient.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientName);
                LabelSSN.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientSnum);
            }
        } catch (Exception ex) {
            //Redirect to message that session is ended and need to log back in from CPRS.
            Exception _tbilogerror = HandleTBIException(ex, "Whodas-i.aspx", "100027", "SESSIOENDED");
            Response.Redirect("Warning.aspx?err=2", false);
        }

        if (!IsPostBack) {
            if (instrumentType.Status != null) {
                _tbiInstrumentManager.TbiServiceTo.SelectedInstrumentType = instrumentType;
            }

            string _snum = "";
            if (_tbiInstrumentManager.TbiServiceTo != null) {
                _snum = _tbiInstrumentManager.TbiServiceTo.PatientSnum;
            }

            if (!string.IsNullOrEmpty(_snum))
            {
                string patICN = patientManager.GetPatientICNBySnum(_snum);

                if (!string.IsNullOrEmpty(patICN)) {
                    ViewState["PatientICN"] = patICN;
                    RefreshSurvey(patICN);
                } else {
                    throw new ArgumentException("Patient with this SSN does not exist.");
                }

                if (_survey != null && !_survey.isNew)
                {
                    SetUpSurvey(_survey);
                    //calculateTotal();
                }
                string referrer = "";
                if (Request.UrlReferrer != null) {
                    referrer = Request.UrlReferrer.PathAndQuery;
                }
                ViewState["referrer"] = referrer;
            }

            //Check if the request is to start a new item 
            //a new item page request is signified when the querystring parameter id equals zero or is not present
            if (_tbiInstrumentManager.TbiServiceTo == null)
            {
                Logging.WriteLogToFile("Whodas-i.Page_Load(): WarningRedirect: _tbiInstrumentManager.TbiServiceTo == null");
                //Redirect to message that session is ended and need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            } else {
                LabelPatient.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientName);
                LabelSSN.Text = BusinessHelper.FixStringToPreventXss(_tbiInstrumentManager.TbiServiceTo.PatientSnum.Trim().Length == 9 ? String.Format("{0:000-00-0000}", int.Parse(_tbiInstrumentManager.TbiServiceTo.PatientSnum)) : _tbiInstrumentManager.TbiServiceTo.PatientSnum);
            }
        }
        QuestionList = GetAllQuestionsForSurvey();

        // Set control values for Diagnosis Question
        ctrlDiagnosis.QuestionText = GetQuestionText("DX");
        ctrlDiagnosis.SurveyTypeCode = HiddenSurveyType.Value;

        LabelDate1.Text = GetQuestionText("D");
        LabelForF1.Text = GetQuestionText("F1");
        LabelForF2.Text = GetQuestionText("F2");
        LabelForF3.Text = GetQuestionText("F3");
        LabelForF4.Text = GetQuestionText("F4");
        LabelForF5.Text = GetQuestionText("F5");
        LabelForA1.Text = GetQuestionText("A1");
        LabelForA2.Text = GetQuestionText("A2");
        LabelForA3.Text = GetQuestionText("A3");
        LabelForA4.Text = GetQuestionText("A4");
        LabelForA5.Text = GetQuestionText("A5");
        LabelForS1.Text = GetQuestionText("S1");
        LabelForS2.Text = GetQuestionText("S2");
        LabelForS3.Text = GetQuestionText("S3");
        LabelForS4.Text = GetQuestionText("S4");
        LabelForS5.Text = GetQuestionText("S5");
        LabelForS6.Text = GetQuestionText("S6");
        LabelForS7.Text = GetQuestionText("S7");
        LabelForS8.Text = GetQuestionText("S8");
        LabelForS9.Text = GetQuestionText("S9");
        LabelForS10.Text = GetQuestionText("S10");
        LabelForS11.Text = GetQuestionText("S11");
        LabelForS12.Text = GetQuestionText("S12");
        LabelForH1.Text = GetQuestionText("H1");
        LabelForH2.Text = GetQuestionText("H2");
        LabelForH3.Text = GetQuestionText("H3");
        LabelForS5Score.Text = GetQuestionText("S5Score");
        LabelForS11Score.Text = GetQuestionText("S11Score");
        LabelForS12Score.Text = GetQuestionText("S12Score");

        dpDate1.MaxDate = DateTime.Now;
    }


    protected void rblA5_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (rblA5.SelectedItem.Text.ToUpper() == "OTHER")
        {
            txtA5Other.Visible = true;
        }
        else
        {
            txtA5Other.Visible = false;
        }
    }

    protected override void LoadViewState(object savedState) {
        base.LoadViewState(savedState);
        string surveyXml = (string)ViewState["surveyXml"];
        _survey = SerializerUtil.Deserialize<SURVEY>(surveyXml);
    }

    protected override object SaveViewState() {
        ViewState["surveyXml"] = _survey.Serialize();
        return base.SaveViewState();
    }

    /// <summary>
    /// Returns the Question_Text of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected string GetQuestionText(string questionId) {
        foreach (STD_QUESTION ques in QuestionList) {
            if (ques.QUESTION_NUMBER.ToLower() == questionId.ToLower()) {
                return ques.QUESTION_TEXT;
            }
        }
        return "";
    }

    /// <summary>
    /// Returns the Question_Id of the question with the passed Question_Number field
    /// </summary>
    /// <param name="questionId"></param>
    /// <returns></returns>
    protected int GetQuestionId(string questionNumber) {
        foreach (STD_QUESTION ques in QuestionList) {
            if (ques.QUESTION_NUMBER.ToLower() == questionNumber.ToLower()) {
                return ques.ID;
            }
        }

        return 0;
    }

    /// <summary>
    /// Save Draft button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    public void btnSaveSurveyDraft_Click(object sender, EventArgs e) {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        SaveCompleteSurvey(ref status);
        SetUpSurvey(_survey);
    }

    /// <summary>
    /// Save and Prepare Note button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnSubmit_Click(object sender, EventArgs e) {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSubmitSurvey.Text + " button again to avoid data loss.";
        SaveCompleteSurvey(ref status);

        if (status > 0) {
            Session["survey"] = _survey;
            Response.Redirect("InstrumentSummaryNote.aspx", false);
        } else {
            SetUpSurvey(_survey); //Follow Save Draft logic 
        }
    }

    /// <summary>
    /// Inactive timer firing.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void InActiveTimer_Tick(object sender, EventArgs e) {
        Int32 status = 0;
        SaveFailMessage = "Save Failed. Please press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";

        Page.Validate();

        if (Page.IsValid) {
            SaveCompleteSurvey(ref status);
            //SetUpSurvey(_survey);
            Response.Redirect("Whodas-i.aspx", false);
        } else {
            SaveFailMessage = "Auto-Save Validation Failed. Please complete required fields in the survey and press " + btnSaveSurveyDraft.Text + " button again to avoid data loss.";
        }
    }

    /// <summary>
    /// Cancel button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCancel_Click(object sender, EventArgs e) {
        ViewState["surveyXml"] = null;
        ViewState["PatientICN"] = null;
        ViewState["referrer"] = null;
        Session.Remove("survey");
        Response.Redirect("Instrument.aspx", false);
        //this.ClientScript.RegisterStartupScript(typeof(Page), "closePage", "<script type='text/javascript'> window.open('','_self','');window.close(); </script>");
    }

    /// <summary>
    /// Hide or Show instructions
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void lnkBtnToggleInstructions_OnClick(object sender, EventArgs e) {
        if (PanelInstructions.Visible) {
            PanelInstructions.Visible = false;
            lnkBtnToggleInstructions.Text = "Click for Instructions";
        } else {
            PanelInstructions.Visible = true;
            lnkBtnToggleInstructions.Text = "Hide Instructions";
        }
    }


    /// <summary>
    /// Calculate button clicked.
    /// </summary>
    /// <param name="sender"></param>
    /// <param name="e"></param>
    protected void btnCalculate_Click(object sender, EventArgs e)
    {
        // perform calculation
        calculateTotal();
    }


    /// <summary>
    /// Calculate total score.
    /// </summary>
    protected void calculateTotal()
    {
        STD_QUESTION_CHOICE choice;
        bool isSurveyCompletelyFilledOut = true;

        int sp1 = 0;
        int sp2 = 0;
        int sp3 = 0;
        int sp4 = 0;
        int sp5 = 0;
        int sp6 = 0;
        int sp7 = 0;
        int sp8 = 0;
        int sp9 = 0;
        int sp10 = 0;
        int sp11 = 0;
        int sp12 = 0;
        double screen5 = 0;
        double screen11 = 0;
        double screen12 = 0;

        foreach (STD_QUESTION question in QuestionList)
        {
            switch (question.QUESTION_NUMBER)
            {
                case "S1":
                    if (!String.IsNullOrEmpty(rblS1.SelectedValue))
                    {
                        choice = question.STD_QUESTION_CHOICEs.FirstOrDefault(C => C.CHOICE_TEXT.ToLower() == rblS1.SelectedItem.Text.ToLower());
                        if (choice != null)
                        {
                            switch (Convert.ToInt32(choice.CHOICE_NAME))
                            {
                                case 1:
                                    sp1 = 0;
                                    break;
                                case 2:
                                    sp1 = 1;
                                    break;
                                case 3:
                                    sp1 = 2;
                                    break;
                                case 4:
                                    sp1 = 3;
                                    break;
                                case 5:
                                    sp1 = 4;
                                    break;
                                default:
                                    break;
                            }
                        }
                    }
                    else
                    {
                        isSurveyCompletelyFilledOut = false;
                    }
                    break;
                case "S2":
                    if (!String.IsNullOrEmpty(rblS2.SelectedValue))
                    {
                        choice = question.STD_QUESTION_CHOICEs.FirstOrDefault(C => C.CHOICE_TEXT.ToLower() == rblS2.SelectedItem.Text.ToLower());
                        if (choice != null)
                        {
                            switch (Convert.ToInt32(choice.CHOICE_NAME))
                            {
                                case 1:
                                    sp2 = 0;
                                    break;
                                case 2:
                                    sp2 = 1;
                                    break;
                                case 3:
                                    sp2 = 1;
                                    break;
                                case 4:
                                    sp2 = 2;
                                    break;
                                case 5:
                                    sp2 = 2;
                                    break;
                                default:
                                    break;
                            }
                        }
                    }
                    else
                    {
                        isSurveyCompletelyFilledOut = false;
                    }
                    break;
                case "S3":
                    if (!String.IsNullOrEmpty(rblS3.SelectedValue))
                    {
                        choice = question.STD_QUESTION_CHOICEs.FirstOrDefault(C => C.CHOICE_TEXT.ToLower() == rblS3.SelectedItem.Text.ToLower());
                        if (choice != null)
                        {
                            switch (Convert.ToInt32(choice.CHOICE_NAME))
                            {
                                case 1:
                                    sp3 = 0;
                                    break;
                                case 2:
                                    sp3 = 1;
                                    break;
                                case 3:
                                    sp3 = 2;
                                    break;
                                case 4:
                                    sp3 = 3;
                                    break;
                                case 5:
                                    sp3 = 4;
                                    break;
                                default:
                                    break;
                            }
                        }
                    }
                    else
                    {
                        isSurveyCompletelyFilledOut = false;
                    }
                    break;
                case "S4":
                    if (!String.IsNullOrEmpty(rblS4.SelectedValue))
                    {
                        choice = question.STD_QUESTION_CHOICEs.FirstOrDefault(C => C.CHOICE_TEXT.ToLower() == rblS4.SelectedItem.Text.ToLower());
                        if (choice != null)
                        {
                            switch (Convert.ToInt32(choice.CHOICE_NAME))
                            {
                                case 1:
                                    sp4 = 0;
                                    break;
                                case 2:
                                    sp4 = 1;
                                    break;
                                case 3:
                                    sp4 = 1;
                                    break;
                                case 4:
                                    sp4 = 2;
                                    break;
                                case 5:
                                    sp4 = 2;
                                    break;
                                default:
                                    break;
                            }
                        }
                    }
                    else
                    {
                        isSurveyCompletelyFilledOut = false;
                    }
                    break;
                case "S5":
                    if (!String.IsNullOrEmpty(rblS5.SelectedValue))
                    {
                        choice = question.STD_QUESTION_CHOICEs.FirstOrDefault(C => C.CHOICE_TEXT.ToLower() == rblS5.SelectedItem.Text.ToLower());
                        if (choice != null)
                        {
                            switch (Convert.ToInt32(choice.CHOICE_NAME))
                            {
                                case 1:
                                    sp5 = 0;
                                    break;
                                case 2:
                                    sp5 = 1;
                                    break;
                                case 3:
                                    sp5 = 2;
                                    break;
                                case 4:
                                    sp5 = 3;
                                    break;
                                case 5:
                                    sp5 = 4;
                                    break;
                                default:
                                    break;
                            }
                        }
                    }
                    else
                    {
                        isSurveyCompletelyFilledOut = false;
                    }
                    break;
                case "S6":
                    if (!String.IsNullOrEmpty(rblS6.SelectedValue))
                    {
                        choice = question.STD_QUESTION_CHOICEs.FirstOrDefault(C => C.CHOICE_TEXT.ToLower() == rblS6.SelectedItem.Text.ToLower());
                        if (choice != null)
                        {
                            switch (Convert.ToInt32(choice.CHOICE_NAME))
                            {
                                case 1:
                                    sp6 = 0;
                                    break;
                                case 2:
                                    sp6 = 1;
                                    break;
                                case 3:
                                    sp6 = 2;
                                    break;
                                case 4:
                                    sp6 = 3;
                                    break;
                                case 5:
                                    sp6 = 4;
                                    break;
                                default:
                                    break;
                            }
                        }
                    }
                    else
                    {
                        isSurveyCompletelyFilledOut = false;
                    }
                    break;

                case "S7":
                    if (!String.IsNullOrEmpty(rblS7.SelectedValue))
                    {
                        choice = question.STD_QUESTION_CHOICEs.FirstOrDefault(C => C.CHOICE_TEXT.ToLower() == rblS7.SelectedItem.Text.ToLower());
                        if (choice != null)
                        {
                            switch (Convert.ToInt32(choice.CHOICE_NAME))
                            {
                                case 1:
                                    sp7 = 0;
                                    break;
                                case 2:
                                    sp7 = 1;
                                    break;
                                case 3:
                                    sp7 = 2;
                                    break;
                                case 4:
                                    sp7 = 3;
                                    break;
                                case 5:
                                    sp7 = 4;
                                    break;
                                default:
                                    break;
                            }
                        }
                    }
                    else
                    {
                        isSurveyCompletelyFilledOut = false;
                    }
                    break;

                case "S8":
                    if (!String.IsNullOrEmpty(rblS8.SelectedValue))
                    {
                        choice = question.STD_QUESTION_CHOICEs.FirstOrDefault(C => C.CHOICE_TEXT.ToLower() == rblS8.SelectedItem.Text.ToLower());
                        if (choice != null)
                        {
                            switch (Convert.ToInt32(choice.CHOICE_NAME))
                            {
                                case 1:
                                    sp8 = 0;
                                    break;
                                case 2:
                                    sp8 = 1;
                                    break;
                                case 3:
                                    sp8 = 1;
                                    break;
                                case 4:
                                    sp8 = 2;
                                    break;
                                case 5:
                                    sp8 = 2;
                                    break;
                                default:
                                    break;
                            }
                        }
                    }
                    else
                    {
                        isSurveyCompletelyFilledOut = false;
                    }
                    break;

                case "S9":
                    if (!String.IsNullOrEmpty(rblS9.SelectedValue))
                    {
                        choice = question.STD_QUESTION_CHOICEs.FirstOrDefault(C => C.CHOICE_TEXT.ToLower() == rblS9.SelectedItem.Text.ToLower());
                        if (choice != null)
                        {
                            switch (Convert.ToInt32(choice.CHOICE_NAME))
                            {
                                case 1:
                                    sp9 = 0;
                                    break;
                                case 2:
                                    sp9 = 1;
                                    break;
                                case 3:
                                    sp9 = 2;
                                    break;
                                case 4:
                                    sp9 = 3;
                                    break;
                                case 5:
                                    sp9 = 4;
                                    break;
                                default:
                                    break;
                            }
                        }
                    }
                    else
                    {
                        isSurveyCompletelyFilledOut = false;
                    }
                    break;

                case "S10":
                    if (!String.IsNullOrEmpty(rblS10.SelectedValue))
                    {
                        choice = question.STD_QUESTION_CHOICEs.FirstOrDefault(C => C.CHOICE_TEXT.ToLower() == rblS10.SelectedItem.Text.ToLower());
                        if (choice != null)
                        {
                            switch (Convert.ToInt32(choice.CHOICE_NAME))
                            {
                                case 1:
                                    sp10 = 0;
                                    break;
                                case 2:
                                    sp10 = 1;
                                    break;
                                case 3:
                                    sp10 = 1;
                                    break;
                                case 4:
                                    sp10 = 2;
                                    break;
                                case 5:
                                    sp10 = 2;
                                    break;
                                default:
                                    break;
                            }
                        }
                    }
                    else
                    {
                        isSurveyCompletelyFilledOut = false;
                    }
                    break;

                case "S11":
                    if (!String.IsNullOrEmpty(rblS11.SelectedValue))
                    {
                        choice = question.STD_QUESTION_CHOICEs.FirstOrDefault(C => C.CHOICE_TEXT.ToLower() == rblS11.SelectedItem.Text.ToLower());
                        if (choice != null)
                        {
                            switch (Convert.ToInt32(choice.CHOICE_NAME))
                            {
                                case 1:
                                    sp11 = 0;
                                    break;
                                case 2:
                                    sp11 = 1;
                                    break;
                                case 3:
                                    sp11 = 1;
                                    break;
                                case 4:
                                    sp11 = 2;
                                    break;
                                case 5:
                                    sp11 = 2;
                                    break;
                                default:
                                    break;
                            }
                        }
                    }
                    else
                    {
                        isSurveyCompletelyFilledOut = false;
                    }
                    break;

                case "S12":
                    if (!String.IsNullOrEmpty(rblS12.SelectedValue))
                    {
                        choice = question.STD_QUESTION_CHOICEs.FirstOrDefault(C => C.CHOICE_TEXT.ToLower() == rblS12.SelectedItem.Text.ToLower());
                        if (choice != null)
                        {
                            switch (Convert.ToInt32(choice.CHOICE_NAME))
                            {
                                case 1:
                                    sp12 = 0;
                                    break;
                                case 2:
                                    sp12 = 1;
                                    break;
                                case 3:
                                    sp12 = 1;
                                    break;
                                case 4:
                                    sp12 = 2;
                                    break;
                                case 5:
                                    sp12 = 2;
                                    break;
                                default:
                                    break;
                            }
                        }
                    }
                    else
                    {
                        isSurveyCompletelyFilledOut = false;
                    }
                    break;

                default:
                    break;
            }
        }

        screen5 = (sp1 + sp2 + sp3 + sp4 + sp5) * 100 / 16;
        screen11 = (sp1 + sp2 + sp3 + sp4 + sp5 + sp6 + sp7 + sp8 + sp9 + sp10 + sp11) * 100 / 34;
        screen12 = (sp1 + sp2 + sp3 + sp4 + sp5 + sp6 + sp7 + sp8 + sp9 + sp10 + sp11 + sp12) * 100 / 36;

        lblS5Score.Text = screen5.ToString();
        lblS11Score.Text = screen11.ToString();
        lblS12Score.Text = screen12.ToString();

        if (isSurveyCompletelyFilledOut)
        {
            lblSurveyError.Text = "";
        }
        else
        {
            // ERROR ... 
            lblSurveyError.Text = "ERROR: Survey is not completed."; // TODO - Alert error.
        }
    }



    #endregion


    #region Private Methods


    /// <summary>
    /// Get all questions for this survey
    /// </summary>
    /// <returns></returns>
    private List<STD_QUESTION> GetAllQuestionsForSurvey() {
        return _tbiInstrumentManager.SelectAllQuestions(_surveyTypeId).ToList();
    }

    /// <summary>
    /// Refresh Survey
    /// </summary>
    /// <param name="patientICN"></param>
    private void RefreshSurvey(string patientICN) {
        var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();

        if (surveys.Count > 0) {
            _survey = surveys.First();
        } else {
            _survey = new SURVEY();
        }

        _survey.SetAsChangeTrackingRoot();
    }

    /// <summary>
    /// Save Complete Survey
    /// </summary>
    /// <param name="status"></param>
    private void SaveCompleteSurvey(ref Int32 status) {
        Page.Validate();
        if (Page.IsValid)
        {
        //if ((Page.IsValid) && IsQRPT1Valid() && Is28ABValid()) {
            string patientICN = String.Empty;

            status = 0;

            //Retrieve patient's ICN from the session variable
            if (ViewState["PatientICN"] != null) {
                patientICN = ViewState["PatientICN"].ToString();
                if (String.IsNullOrEmpty(patientICN.Trim()))
                {
                    Logging.WriteLogToFile("Whodas-i.SaveCompletedSurvey(): WarningRedirect: String.IsNullOrEmpty(patientICN.Trim()");
                    //Lost state. Redirect to message that need to log back in from CPRS.
                    Response.Redirect("Warning.aspx?err=2", false);
                }
            }
            else
            {
                Logging.WriteLogToFile("Whodas-i.SaveCompletedSurvey(): WarningRedirect: ViewState[PatientICN] != null");
                //Lost state. Redirect to message that need to log back in from CPRS.
                Response.Redirect("Warning.aspx?err=2");
            }

            if (_survey != null) {
                if (_survey.isNew) {
                    //Ensure that a concurrent session hasn't already inserted a record for this survey
                    var surveys = _tbiInstrumentManager.SelectByPatientICNAndSurveyType(patientICN, _surveyTypeId, true).ToList();

                    if (surveys.Count > 0)
                    {
                        Logging.WriteLogToFile("Whodas-i.SaveCompletedSurvey(): WarningRedirect: surveys.Count > 0");
                        //A concurrent session has already inserted a record for this survey and it is not new anymore.
                        Response.Redirect("Warning.aspx?err=9", false);
                    } else {
                        _survey.SURVEY_STATUS = "inprocess";

                        _survey.SetAsInsertOnSubmit();

                        _survey.patient_ICN = patientICN;

                        _survey.STD_SURVEY_TYPE_ID = _surveyTypeId;

                        // TODO: change to datepicker
                        _survey.SURVEY_DATE = DateTime.Today;

                        //Save survey if it's new before adding any responses
                        SuppressSaveMessage = true;
                        _tbiInstrumentManager.Update(_survey);
                        SuppressSaveMessage = false;

                        RefreshSurvey(patientICN);
                    }
                }

                SaveSurvey(ref _survey);

                _survey.SetAsUpdateOnSubmit();
                status = _tbiInstrumentManager.Update(_survey);

                //Fortify errors on this line (this.Master as RegistryInstrumentMaster).SetDirtyFlag(false);
                ((RegistryInstrumentMaster)Master).SetDirtyFlag(false);

                RefreshSurvey(patientICN);
                SuppressSaveMessage = false;
            }
        }
    }



    /// <summary>
    /// Save survey.
    /// </summary>
    /// <param name="survey"></param>
    private void SaveSurvey(ref SURVEY survey)
    {
        calculateTotal(); // call to re-calculate total score.

        // Ensure lblSurveyError does not contain - ERROR
        if (!lblSurveyError.Text.Contains("ERROR"))
        {
            List<STD_QUESTION> questions = GetAllQuestionsForSurvey();

            //Delete all the survey results from database if there are any.
            SURVEY surveyWithResults = _tbiInstrumentManager.GetSurveyWithAllAnswers(survey.SURVEYS_ID);
            _tbiInstrumentManager.DeleteAllSurveyResults(surveyWithResults);



            // Question DX
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question DX choice
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(ctrlDiagnosis.GetSelectedId());
                _surveyResult.RESULT_TEXT = ctrlDiagnosis.GetSelectedResultText();
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question DX");
            }

            // Question D
            _surveyResult = new SURVEY_RESULT();
            if (dpDate1.SelectedDate != null)
            {
                STD_QUESTION questionD = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "D");
                _surveyResult = new SURVEY_RESULT();
                try
                {
                    // Add Question DTE choice
                    _surveyResult.STD_QUESTION_CHOICE_ID = questionD.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                    _surveyResult.RESULT_TEXT = ((DateTime)dpDate1.SelectedDate).ToShortDateString();
                    survey.SURVEY_RESULTs.Add(_surveyResult);
                }
                catch (Exception surveyEx)
                {
                    Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question D");
                }
            }


            STD_QUESTION questionF1 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "F1");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = questionF1.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtF1.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question F1");
            }


            STD_QUESTION questionF2 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "F2");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = questionF2.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtF2.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question F2");
            }


            STD_QUESTION questionF3 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "F3");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = questionF3.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtF3.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question F3");
            }


            // Question F4
            _surveyResult = new SURVEY_RESULT();
            if (dpDateF4.SelectedDate != null)
            {
                STD_QUESTION questionF4 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "F4");
                _surveyResult = new SURVEY_RESULT();
                try
                {
                    _surveyResult.STD_QUESTION_CHOICE_ID = questionF4.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                    _surveyResult.RESULT_TEXT = ((DateTime)dpDateF4.SelectedDate).ToShortDateString();
                    survey.SURVEY_RESULTs.Add(_surveyResult);
                }
                catch (Exception surveyEx)
                {
                    Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question F4");
                }
            }

            // Question F5
            STD_QUESTION questionF5 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "F5");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblF5.SelectedValue);
                _surveyResult.RESULT_TEXT = rblF5.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question F5");
            }


            // Question A1
            STD_QUESTION questionA1 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "A1");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblA1.SelectedValue);
                _surveyResult.RESULT_TEXT = rblA1.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question A1");
            }

            STD_QUESTION questionA2 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "A2");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = questionA2.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtA2.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question A2");
            }

            STD_QUESTION questionA3 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "A3");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = questionA3.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtA3.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question A3");
            }

            // Question A4
            STD_QUESTION questionA4 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "A4");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblA4.SelectedValue);
                _surveyResult.RESULT_TEXT = rblA4.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question A4");
            }

            // Question A5
            STD_QUESTION questionA5 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "A5");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblA5.SelectedValue);
                if (rblA5.SelectedItem.Text.ToUpper() == "OTHER")
                {
                    _surveyResult.RESULT_TEXT = "Other: " + txtA5Other.Text.Trim();
                }
                else
                {
                    _surveyResult.RESULT_TEXT = rblA5.SelectedItem.Text;
                }
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question A5");
            }
            
            // Question S1
            STD_QUESTION questionS1 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S1");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblS1.SelectedValue);
                _surveyResult.RESULT_TEXT = rblS1.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question S1");
            }

            // Question S2
            STD_QUESTION questionS2 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S2");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblS2.SelectedValue);
                _surveyResult.RESULT_TEXT = rblS2.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question S2");
            }
            
            // Question S3
            STD_QUESTION questionS3 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S3");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblS3.SelectedValue);
                _surveyResult.RESULT_TEXT = rblS3.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question S3");
            }
            
            // Question S4
            STD_QUESTION questionS4 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S4");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblS4.SelectedValue);
                _surveyResult.RESULT_TEXT = rblS4.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question S4");
            }

            // Question S5
            STD_QUESTION questionS5 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S5");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblS5.SelectedValue);
                _surveyResult.RESULT_TEXT = rblS5.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question S5");
            }
            
            // Question S6
            STD_QUESTION questionS6 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S6");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblS6.SelectedValue);
                _surveyResult.RESULT_TEXT = rblS6.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question S6");
            }
            
            // Question S7
            STD_QUESTION questionS7 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S7");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblS7.SelectedValue);
                _surveyResult.RESULT_TEXT = rblS7.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question S7");
            }

            // Question S8
            STD_QUESTION questionS8 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S8");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblS8.SelectedValue);
                _surveyResult.RESULT_TEXT = rblS8.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question S8");
            }

            // Question S9
            STD_QUESTION questionS9 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S9");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblS9.SelectedValue);
                _surveyResult.RESULT_TEXT = rblS9.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question S9");
            }

            // Question S10
            STD_QUESTION questionS10 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S10");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblS10.SelectedValue);
                _surveyResult.RESULT_TEXT = rblS10.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question S10");
            }

            // Question S11
            STD_QUESTION questionS11 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S11");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblS11.SelectedValue);
                _surveyResult.RESULT_TEXT = rblS11.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question S11");
            }
            
            // Question S12
            STD_QUESTION questionS12 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S12");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = Convert.ToInt32(rblS12.SelectedValue);
                _surveyResult.RESULT_TEXT = rblS12.SelectedItem.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question S12");
            }

            // Question H1
            STD_QUESTION questionH1 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "H1");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = questionH1.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtH1.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question H1");
            }

            // Question H2
            STD_QUESTION questionH2 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "H2");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = questionH2.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtH2.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question H2");
            }

            // Question H3
            STD_QUESTION questionH3 = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "H3");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                _surveyResult.STD_QUESTION_CHOICE_ID = questionH3.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = txtH3.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question H3");
            }


            // Question S5Score
            STD_QUESTION questionS5Score = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S5Score");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question S5Score choice
                _surveyResult.STD_QUESTION_CHOICE_ID = questionS5Score.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = lblS5Score.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question S5Score");
            }

            // Question S11Score
            STD_QUESTION questionS11Score = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S11Score");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question S11Score choice
                _surveyResult.STD_QUESTION_CHOICE_ID = questionS11Score.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = lblS11Score.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question S11Score");
            }

            // Question S12Score
            STD_QUESTION questionS12Score = questions.FirstOrDefault(Q => Q.QUESTION_NUMBER == "S12Score");
            _surveyResult = new SURVEY_RESULT();
            try
            {
                // Add Question S12Score choice
                _surveyResult.STD_QUESTION_CHOICE_ID = questionS12Score.STD_QUESTION_CHOICEs.FirstOrDefault().STD_QUESTION_CHOICE_ID;
                _surveyResult.RESULT_TEXT = lblS12Score.Text;
                survey.SURVEY_RESULTs.Add(_surveyResult);
            }
            catch (Exception surveyEx)
            {
                Exception _tbilogerror = HandleTBIException(surveyEx, "Whodas-i.aspx", "100027", "SaveSurvey() - Question S12Score");
            }
        }
        else
        {
            // do not save ... 
        }
    }// END SaveSurvey




    /// <summary>
    /// Initialize/setup controls
    /// </summary>
    /// <param name="survey"></param>
    private void SetUpSurvey(SURVEY survey) {
        int months = 0;
        int years = 0;
        try {
            foreach (var sResult in survey.SURVEY_RESULTs) {
                switch (sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_NUMBER) {
                    case "DX":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            ctrlDiagnosis.SelectedChoiceId = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();

                            if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToLower().Contains("other"))
                            {
                                ctrlDiagnosis.SetOtherDescriptionText(sResult.RESULT_TEXT);
                            }
                        }
                        else
                        {
                            ctrlDiagnosis.SelectedChoiceId = null;
                        }
                        break;
                    case "D":
                        if (!String.IsNullOrEmpty(sResult.RESULT_TEXT)) {
                            DateTime temp;
                            if (DateTime.TryParse(sResult.RESULT_TEXT, out temp)) {
                                dpDate1.SelectedDate = temp;
                            }
                        }
                        break;
                    case "F1":
                        txtF1.Text = sResult.RESULT_TEXT;
                        break;
                    case "F2":
                        txtF2.Text = sResult.RESULT_TEXT;
                        break;
                    case "F3":
                        txtF3.Text = sResult.RESULT_TEXT;
                        break;
                    case "F4":
                        if (!String.IsNullOrEmpty(sResult.RESULT_TEXT))
                        {
                            DateTime temp;
                            if (DateTime.TryParse(sResult.RESULT_TEXT, out temp))
                            {
                                dpDateF4.SelectedDate = temp;
                            }
                        }
                        break;
                    case "F5":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblF5.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblF5.SelectedIndex = -1;
                        }
                        break;
                    case "A1":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblA1.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblA1.SelectedIndex = -1;
                        }
                        break;
                    case "A2":
                        txtA2.Text = sResult.RESULT_TEXT;
                        break;
                    case "A3":
                        txtA3.Text = sResult.RESULT_TEXT;
                        break;
                    case "A4":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblA4.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblA4.SelectedIndex = -1;
                        }
                        break;
                    case "A5":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            //if (sResult.STD_QUESTION_CHOICE.STD_QUESTION.QUESTION_TEXT.ToUpper().Substring(0, 5) == "OTHER")
                            if (sResult.STD_QUESTION_CHOICE.CHOICE_TEXT.ToUpper().Substring(0,5) == "OTHER")
                            {
                                if (sResult.RESULT_TEXT.ToUpper().Substring(0, 7) == "OTHER: ")
                                {
                                    txtA5Other.Text = sResult.RESULT_TEXT.Substring(7);
                                }
                                else
                                {
                                    txtA5Other.Text = sResult.RESULT_TEXT;
                                }
                                txtA5Other.Visible = true;
                            }
                            else
                            {
                                //rblA5.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                                txtA5Other.Visible = false;
                            }
                            rblA5.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblA5.SelectedIndex = -1;
                        }
                        break;
                    case "S1":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblS1.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblS1.SelectedIndex = -1;
                        }
                        break;
                    case "S2":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblS2.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblS2.SelectedIndex = -1;
                        }
                        break;
                    case "S3":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblS3.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblS3.SelectedIndex = -1;
                        }
                        break;
                    case "S4":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblS4.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblS4.SelectedIndex = -1;
                        }
                        break;
                    case "S5":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblS5.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblS5.SelectedIndex = -1;
                        }
                        break;
                    case "S6":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblS6.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblS6.SelectedIndex = -1;
                        }
                        break;
                    case "S7":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblS7.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblS7.SelectedIndex = -1;
                        }
                        break;
                    case "S8":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblS8.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblS8.SelectedIndex = -1;
                        }
                        break;
                    case "S9":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblS9.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblS9.SelectedIndex = -1;
                        }
                        break;
                    case "S10":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblS10.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblS10.SelectedIndex = -1;
                        }
                        break;
                    case "S11":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblS11.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblS11.SelectedIndex = -1;
                        }
                        break;
                    case "S12":
                        if (sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID > -1)
                        {
                            rblS12.SelectedValue = sResult.STD_QUESTION_CHOICE.STD_QUESTION_CHOICE_ID.ToString();
                        }
                        else
                        {
                            rblS12.SelectedIndex = -1;
                        }
                        break;
                    case "H1":
                        txtH1.Text = sResult.RESULT_TEXT;
                        break;
                    case "H2":
                        txtH2.Text = sResult.RESULT_TEXT;
                        break;
                    case "H3":
                        txtH3.Text = sResult.RESULT_TEXT;
                        break;
                    case "S5Score":
                        lblS5Score.Text = BusinessHelper.FixStringToPreventXss(sResult.RESULT_TEXT);
                        break;
                    case "S11Score":
                        lblS11Score.Text = BusinessHelper.FixStringToPreventXss(sResult.RESULT_TEXT);
                        break;
                    case "S12Score":
                        lblS12Score.Text = BusinessHelper.FixStringToPreventXss(sResult.RESULT_TEXT);
                        break;
                    
                    default:
                        break;
                }
            }
        }
        catch (Exception ex)
        {
            Exception _tbilogerror = HandleTBIException(ex, "Whodas-i.aspx", "100027", "SetUpSurvey()");
        }
    }
    // END SetUpSurvey

    #endregion
}
